<?php
?>
<!DOCTYPE html>
<html lang='sk'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Reklamačný poriadok - E-známka Slovensko</title>
    <meta name='description' content='Reklamačný poriadok pre ezamki.com - pravidlá reklamácie a vrátenia peňazí.'>
    <link rel='icon' type='image/jpeg' href='images/logo.jpg'>
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css'>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.8;
            color: #333;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        header {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 15px;
            text-decoration: none;
            color: #667eea;
        }
        
        .logo img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        
        .logo h1 {
            font-size: 24px;
            font-weight: bold;
        }
        
        nav ul {
            display: flex;
            list-style: none;
            gap: 30px;
        }
        
        nav a {
            text-decoration: none;
            color: #333;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        nav a:hover {
            color: #667eea;
        }
        
        .page-hero {
            background: linear-gradient(rgba(102, 126, 234, 0.9), rgba(118, 75, 162, 0.9));
            color: white;
            padding: 60px 0;
            text-align: center;
        }
        
        .page-hero h2 {
            font-size: 42px;
            margin-bottom: 10px;
        }
        
        .main-content {
            background: white;
            margin: -30px auto 40px;
            border-radius: 20px;
            padding: 60px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            max-width: 900px;
        }
        
        .main-content h3 {
            color: #667eea;
            font-size: 26px;
            margin-top: 30px;
            margin-bottom: 15px;
        }
        
        .main-content h4 {
            color: #764ba2;
            font-size: 20px;
            margin-top: 20px;
            margin-bottom: 10px;
        }
        
        .main-content p {
            margin-bottom: 15px;
            font-size: 16px;
        }
        
        .main-content ul, .main-content ol {
            margin: 15px 0;
            padding-left: 30px;
        }
        
        .main-content li {
            margin-bottom: 8px;
        }
        
        .highlight-box {
            background: #d4edda;
            border-left: 5px solid #28a745;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        
        .warning-box {
            background: #f8d7da;
            border-left: 5px solid #dc3545;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        
        .info-box {
            background: #d1ecf1;
            border-left: 5px solid #17a2b8;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        
        footer {
            background: #2d3436;
            color: white;
            padding: 30px 0;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
            }
            
            nav ul {
                flex-direction: column;
                gap: 10px;
            }
            
            .main-content {
                padding: 30px 20px;
            }
            
            .page-hero h2 {
                font-size: 28px;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class='container'>
            <div class='header-content'>
                <a href='index.php' class='logo'>
                    <img src='images/logo.jpg' alt='E-známka Logo'>
                    <h1>E-známka SK</h1>
                </a>
                <nav>
                    <ul>
                        <li><a href='index.php'><i class='fas fa-home'></i> Domov</a></li>
                        <li><a href='blog.php'><i class='fas fa-blog'></i> Blog</a></li>
                        <li><a href='about.php'><i class='fas fa-users'></i> O nás</a></li>
                        <li><a href='contact.php'><i class='fas fa-envelope'></i> Kontakt</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class='page-hero'>
        <div class='container'>
            <h2><i class='fas fa-undo-alt'></i> Reklamačný poriadok</h2>
            <p>Pravidlá reklamácie a vrátenia peňazí</p>
        </div>
    </section>

    <div class='container'>
        <div class='main-content'>
            <p><strong>Dátum účinnosti:</strong> 1. január 2025</p>
            <p><strong>Posledná aktualizácia:</strong> 1. január 2025</p>

            <h3>1. Úvodné ustanovenia</h3>
            <p>Tento Reklamačný poriadok ("Poriadok") upravuje práva a povinnosti prevádzkovateľa webovej stránky ezamki.com ("Prevádzkovateľ", "my") a používateľov ("Používateľ", "vy") v súvislosti s reklamáciami a vráteným peňazí.</p>

            <div class='warning-box'>
                <p><strong><i class='fas fa-exclamation-triangle'></i> Dôležité upozornenie:</strong> Táto webová stránka je výlučne informačný portál. Nepredávame e-známky ani žiadne iné produkty alebo služby, ktoré by podliehali priamemu reklamačnému konaniu. Tento Reklamačný poriadok sa vzťahuje na kvalitu poskytovaných informácií a prípadné technické problémy s webovou stránkou.</p>
            </div>

            <h3>2. Identifikácia prevádzkovateľa</h3>
            <p><strong>Obchodné meno:</strong> ezamki.com<br>
            <strong>IČO:</strong> 91533494<br>
            <strong>Sídlo:</strong> Mišík Drive 86122, 572 56 Lipovec, Slovakia<br>
            <strong>Email:</strong> info@ezamki.com<br>
            <strong>Telefón:</strong> +2670233649327</p>

            <h3>3. Charakter poskytovaných služieb</h3>
            <p>Naša webová stránka poskytuje:</p>
            <ul>
                <li>Bezplatné informácie o elektronickej diaľničnej známke</li>
                <li>Návody a tipy pre vodičov</li>
                <li>Blog články o cestovaní po Slovensku</li>
                <li>Odpovede na často kladené otázky (FAQ)</li>
            </ul>

            <p>Keďže nepredávame žiadne produkty ani služby, tento Reklamačný poriadok sa zameriava na kvalitu poskytovaných informácií a funkcionalitu webovej stránky.</p>

            <h3>4. Práva používateľov</h3>
            
            <h4>4.1 Právo na presné informácie</h4>
            <p>Máte právo očakávať, že informácie na našej webovej stránke sú:</p>
            <ul>
                <li>Presné a aktuálne</li>
                <li>Relevantné a užitočné</li>
                <li>Zrozumiteľne prezentované</li>
                <li>Pravidelne aktualizované</li>
            </ul>

            <h4>4.2 Právo na funkčnú webovú stránku</h4>
            <p>Máte právo očakávať, že webová stránka:</p>
            <ul>
                <li>Je dostupná a funkčná</li>
                <li>Načíta sa v primeranom čase</li>
                <li>Je bezpečná a chráni vaše údaje</li>
                <li>Funguje na rôznych zariadeniach</li>
            </ul>

            <h4>4.3 Právo na podporu</h4>
            <p>Máte právo:</p>
            <ul>
                <li>Kontaktovať nás s otázkami</li>
                <li>Nahlásiť technické problémy</li>
                <li>Požiadať o objasnenie informácií</li>
                <li>Podať sťažnosť na kvalitu služieb</li>
            </ul>

            <h3>5. Reklamačný proces</h3>
            
            <h4>5.1 Dôvody na reklamáciu</h4>
            <p>Reklamáciu môžete podať v nasledujúcich prípadoch:</p>
            <ul>
                <li><strong>Nesprávne informácie:</strong> Zistíte, že informácie na stránke sú nepresné alebo zastarané</li>
                <li><strong>Technické problémy:</strong> Webová stránka nefunguje správne alebo je nedostupná</li>
                <li><strong>Problém s osobnými údajmi:</strong> Vaše údaje neboli spracované v súlade s GDPR</li>
                <li><strong>Nefunkčné odkazy:</strong> Odkazy na stránke vedú na nesprávne miesta</li>
                <li><strong>Problém s obsahom:</strong> Obsah je zavádzajúci alebo neúplný</li>
            </ul>

            <h4>5.2 Ako podať reklamáciu</h4>
            <p>Reklamáciu môžete podať týmito spôsobmi:</p>

            <ol>
                <li><strong>Emailom:</strong> info@ezamki.com
                    <ul>
                        <li>Uveďte podrobný popis problému</li>
                        <li>Pripojte screenshots (ak je to možné)</li>
                        <li>Uveďte dátum a čas, kedy ste problém zaznamenali</li>
                    </ul>
                </li>
                <li><strong>Kontaktným formulárom:</strong> Na stránke contact.php
                    <ul>
                        <li>Vyplňte všetky povinné polia</li>
                        <li>Detailne popíšte problém</li>
                        <li>Uveďte vaše kontaktné údaje</li>
                    </ul>
                </li>
                <li><strong>Poštou:</strong> Mišík Drive 86122, 572 56 Lipovec, Slovakia
                    <ul>
                        <li>Napíšte list s podrobným popisom problému</li>
                        <li>Uveďte vaše kontaktné údaje</li>
                        <li>Pripojte príslušné doklady</li>
                    </ul>
                </li>
            </ol>

            <h4>5.3 Náležitosti reklamácie</h4>
            <p>Reklamácia by mala obsahovať:</p>
            <ul>
                <li>Vaše meno a kontaktné údaje (email, telefón)</li>
                <li>Dátum a čas, kedy ste problém zaznamenali</li>
                <li>Podrobný popis problému</li>
                <li>URL adresu stránky, kde sa problém vyskytol</li>
                <li>Screenshots alebo iné dôkazy (ak sú k dispozícii)</li>
                <li>Vaše požiadavky alebo návrhy na riešenie</li>
            </ul>

            <h3>6. Vybavenie reklamácie</h3>
            
            <h4>6.1 Lehota na vybavenie</h4>
            <p>Zaväzujeme sa vybaviť vašu reklamáciu v nasledujúcich lehotách:</p>
            <ul>
                <li><strong>Potvrdenie prijatia:</strong> Do 24 hodín od podania reklamácie</li>
                <li><strong>Vybavenie reklamácie:</strong> Do 30 dní od podania</li>
                <li><strong>Urgentné prípady:</strong> Do 48 hodín (napr. bezpečnostné problémy)</li>
            </ul>

            <h4>6.2 Proces vybavenia</h4>
            <ol>
                <li><strong>Prijatie reklamácie:</strong> Potvrdíme príjem vašej reklamácie emailom</li>
                <li><strong>Preskúmanie:</strong> Dôkladne preskúmame váš problém</li>
                <li><strong>Overenie:</strong> Overíme faktá a okolnosti reklamácie</li>
                <li><strong>Rozhodnutie:</strong> Prijmeme rozhodnutie o oprávnenosti reklamácie</li>
                <li><strong>Informovanie:</strong> Informujeme vás o výsledku a riešení</li>
                <li><strong>Náprava:</strong> Implementujeme navrhnuté riešenie</li>
            </ol>

            <h4>6.3 Možné výsledky reklamácie</h4>
            <p>Na základe preskúmania môžeme:</p>
            <ul>
                <li><strong>Uznať reklamáciu:</strong> Opravíme problém a informujeme vás</li>
                <li><strong>Čiastočne uznať:</strong> Opravíme časť problému s vysvetlením</li>
                <li><strong>Zamietnuť:</strong> S odôvodnením, prečo reklamácia nie je oprávnená</li>
                <li><strong>Poskytnúť vysvetlenie:</strong> Ak problém nie je na našej strane</li>
            </ul>

            <h3>7. Konkrétne prípady reklamácií</h3>
            
            <h4>7.1 Reklamácia nesprávnych informácií</h4>
            <p>Ak zistíte, že informácie na našej stránke sú nesprávne:</p>
            <ul>
                <li>Uveďte konkrétnu stránku a časť textu</li>
                <li>Popíšte, v čom je informácia nesprávna</li>
                <li>Poskytnite zdroj správnej informácie (ak máte)</li>
                <li>Informáciu overíme a v prípade potvrdenia okamžite opravíme</li>
            </ul>

            <div class='highlight-box'>
                <p><strong><i class='fas fa-check-circle'></i> Naše záväzky:</strong> Zaväzujeme sa opraviť nesprávne informácie do 48 hodín od overenia reklamácie.</p>
            </div>

            <h4>7.2 Reklamácia technických problémov</h4>
            <p>Pri technických problémoch (napr. nefunkčné odkazy, chyby načítania):</p>
            <ul>
                <li>Popíšte, aký prehliadač a zariadenie používate</li>
                <li>Uveďte presné kroky, ktoré viedli k problému</li>
                <li>Pripojte screenshots chybových hlásení</li>
                <li>Problém preskúmame a opravíme čo najskôr</li>
            </ul>

            <h4>7.3 Reklamácia ochrany osobných údajov</h4>
            <p>Ak sa domniavate, že sme porušili vaše práva na ochranu osobných údajov:</p>
            <ul>
                <li>Popíšte, o aké porušenie sa jedná</li>
                <li>Uveďte, akých údajov sa to týka</li>
                <li>Prípad preskúmame s maximálnou prioritou</li>
                <li>Prípadné porušenie okamžite napravíme</li>
                <li>Informujeme vás o prijatých opatreniach</li>
            </ul>

            <h3>8. Odmietnutie reklamácie</h3>
            <p>Reklamáciu môžeme odmietnuť v nasledujúcich prípadoch:</p>
            <ul>
                <li>Reklamácia je zjavne neopodstatnená</li>
                <li>Problém nie je na našej strane (napr. problém s vaším zariadením)</li>
                <li>Reklamácia je podaná po neprimerane dlhej dobe</li>
                <li>Reklamácia obsahuje nepravdivé informácie</li>
                <li>Reklamácia je podaná opakovane bez nových skutočností</li>
            </ul>

            <p>V prípade odmietnutia vám vždy poskytneme podrobné odôvodnenie.</p>

            <h3>9. Odvolanie proti rozhodnutiu</h3>
            <p>Ak nesúhlasíte s vybavením reklamácie, máte právo:</p>
            <ol>
                <li><strong>Požiadať o preskúmanie:</strong> Do 15 dní od oznámenia rozhodnutia</li>
                <li><strong>Poskytnúť dodatočné dôkazy:</strong> Ktoré sme predtým nemali</li>
                <li><strong>Kontaktovať dozorný orgán:</strong> Úrad na ochranu osobných údajov</li>
            </ol>

            <h3>10. Alternatívne riešenie sporov</h3>
            <p>Okrem reklamačného procesu môžete využiť:</p>

            <h4>10.1 Mimosúdne riešenie</h4>
            <p>Pred podaním súdnej žaloby odporúčame pokúsiť sa o mimosúdne riešenie sporu prostredníctvom mediácie alebo arbitráže.</p>

            <h4>10.2 Orgán dozoru</h4>
            <p>Pri problémoch súvisiacich s ochranou osobných údajov sa môžete obrátiť na:</p>
            <div class='info-box'>
                <p><strong>Úrad na ochranu osobných údajov SR</strong><br>
                Hraničná 12<br>
                820 07 Bratislava 27<br>
                Email: statny.dozor@pdp.gov.sk<br>
                Web: www.dataprotection.gov.sk</p>
            </div>

            <h4>10.3 Európska platforma ODR</h4>
            <p>Ako spotrebiteľ máte tiež právo podať sťažnosť prostredníctvom platformy pre riešenie sporov online (ODR) zriadenej Európskou komisiou na adrese: <a href='https://ec.europa.eu/consumers/odr' style='color: #667eea;'>https://ec.europa.eu/consumers/odr</a></p>

            <h3>11. Zlepšovanie služieb</h3>
            <p>Všetky reklamácie a spätnú väzbu používame na zlepšenie našich služieb:</p>
            <ul>
                <li>Pravidelne analyzujeme reklamácie</li>
                <li>Identifikujeme opakujúce sa problémy</li>
                <li>Implementujeme preventívne opatrenia</li>
                <li>Aktualizujeme procesy a postupy</li>
                <li>Školíme náš tím</li>
            </ul>

            <h3>12. Ochrana pred zneužitím</h3>
            <p>Vyhradzujeme si právo odmietnuť vybavenie reklamácie, ak:</p>
            <ul>
                <li>Je podaná s úmyslom poškodiť našu povesť</li>
                <li>Obsahuje urážlivé alebo vulgárne vyjadrenia</li>
                <li>Je podávaná opakovane bez oprávneného dôvodu</li>
                <li>Zneužíva reklamačný proces</li>
            </ul>

            <h3>13. Dokumentácia</h3>
            <p>Všetky reklamácie a ich vybavenie dokumentujeme a archivujeme po dobu 5 rokov. Táto dokumentácia slúži na:</p>
            <ul>
                <li>Evidenciu vybavených reklamácií</li>
                <li>Štatistické účely</li>
                <li>Zlepšovanie kvality služieb</li>
                <li>Prípadné právne spory</li>
            </ul>

            <h3>14. Kontaktné informácie pre reklamácie</h3>
            <div class='highlight-box'>
                <p><strong><i class='fas fa-headset'></i> Reklamačné oddelenie:</strong></p>
                <p><strong>Email:</strong> info@ezamki.com (predmet: "REKLAMÁCIA")<br>
                <strong>Telefón:</strong> +2670233649327 (Po-Pia 9:00-17:00)<br>
                <strong>Poštová adresa:</strong> Mišík Drive 86122, 572 56 Lipovec, Slovakia<br>
                <strong>Kontaktný formulár:</strong> www.ezamki.com/contact.php</p>
            </div>

            <h3>15. Záverečné ustanovenia</h3>
            
            <h4>15.1 Zmeny Reklamačného poriadku</h4>
            <p>Tento Reklamačný poriadok môžeme kedykoľvek zmeniť alebo upraviť. O významných zmenách vás budeme informovať na webovej stránke.</p>

            <h4>15.2 Účinnosť</h4>
            <p>Tento Reklamačný poriadok nadobúda účinnosť dňa 1. januára 2025.</p>

            <h4>15.3 Rozhodné právo</h4>
            <p>Tento Reklamačný poriadok sa riadi a vykladá v súlade so zákonmi Slovenskej republiky, najmä:</p>
            <ul>
                <li>Zákon č. 250/2007 Z.z. o ochrane spotrebiteľa</li>
                <li>Zákon č. 102/2014 Z.z. o ochrane spotrebiteľa pri predaji tovaru alebo poskytovaní služieb</li>
                <li>Zákon č. 18/2018 Z.z. o ochrane osobných údajov</li>
                <li>Občiansky zákonník</li>
            </ul>

            <h3>16. Prístup k informáciám</h3>
            <p>Tento Reklamačný poriadok je voľne dostupný na našej webovej stránke. Môžete si ho kedykoľvek:</p>
            <ul>
                <li>Prečítať online</li>
                <li>Stiahnuť v PDF formáte</li>
                <li>Vytlačiť</li>
                <li>Požiadať o zaslanie emailom</li>
            </ul>

            <div class='info-box'>
                <p><strong><i class='fas fa-info-circle'></i> Vaše spokojnosť je pre nás prioritou.</strong> Snažíme sa poskytovať kvalitné informácie a bezproblémové služby. Ak napriek tomu zaznamenáte akýkoľvek problém, neváhajte nás kontaktovať. Vaša späť väzba nám pomáha zlepšovať.</p>
            </div>

            <p><strong>Ďakujeme za používanie našej webovej stránky a za vašu dôveru.</strong></p>

            <p><em>Posledná aktualizácia: 1. január 2025</em></p>
        </div>
    </div>

    <footer>
        <div class='container'>
            <p>&copy; 2025 ezamki.com - Všetky práva vyhradené | <a href='index.php' style='color: #667eea;'>Domov</a></p>
        </div>
    </footer>
</body>
</html>